#version 130
#extension GL_EXT_gpu_shader4 : enable
// psychedelic #1Mod01.fsh  by   warpGooblin

//https://www.shadertoy.com/view/NsKXzh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//precision highp float;


#define mouse iMouse
#define time iTime

uniform float zoom;

vec3 ti;  // tile index

#define BOXES_STEPS 0.45
#define MAX_STEPS 300
#define MAX_DIST 90.
#define SURF_DIST .001

#define EPSILON 0.0001

float tw()
{
    return sin(time) * 0.5 + 0.5;
}

mat2 Rot(float a)
{
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}


mat3 Rotation3d(vec3 axis, float angle)
{
  axis = normalize(axis);
  float s = sin(angle);
  float c = cos(angle);
  float oc = 1.0 - c;

  return mat3(
    oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  
    oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  
    oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c           
    
    );
}


float smin(float a, float b, float k) {
    float h = clamp( 0.5+0.5*(b-a)/k, 0., 1. );
    return mix(b, a, h) - k*h*(1.0-h);
}

float sdSphere(vec3 p, float s)
{
  return length(p)-s;
}

float sdCapsule(vec3 p, vec3 a, vec3 b, float r)
{
    vec3 ab = b-a;
    vec3 ap = p-a;
    
    float t = dot(ab, ap) / dot(ab, ab);
    t = clamp(t, 0., 1.);
    
    vec3 c = a + t*ab;
    
    return length(p-c)-r;
}

float sdCylinder(vec3 p, vec3 a, vec3 b, float r)
{
    vec3 ab = b-a;
    vec3 ap = p-a;
    
    float t = dot(ab, ap) / dot(ab, ab);
    t = clamp(t, 0., 1.);
    
    vec3 c = a + t*ab;
    
    float x = length(p-c)-r;
    float y = (abs(t-.5)-.5)*length(ab);
    float e = length(max(vec2(x, y), 0.));
    float i = min(max(x, y), 0.);
    
    return e+i;
}

float sdTorus(vec3 p, vec2 r) {
    float x = length(p.xz)-r.x;
    return length(vec2(x, p.y))-r.y;
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
    return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}

vec3 opRep(in vec3 p, in vec3 c)
{
    vec3 q = mod(p+0.5*c,c)-0.5*c;
    ti = floor((p + c*0.5)/c);  // tile index global variable
    return q;
}

vec3 opRepLim(in vec3 p, in float c, in vec3 limita, in vec3 limitb)
{
    //p.y -= 0.75;
    return p - c * clamp(floor(p / c + 0.5), limita, limitb);
}

// www.mercury.sexy/hg_sdf version
/* vec3 pMod3(inout vec3 p, vec3 size) {
    vec3 c = floor((p + size*0.5)/size);
    p = mod(p + size*0.5, size) - size*0.5;
    return c;
} */



float GetDist(vec3 p) {
    //float plane = p.y;
    //float box = sdBox(p-vec3(0,1,0), vec3(1));

    //vec3 r = opRepLim(p, 1.60, vec3(-2.00), vec3(2.00));
    vec3 r = opRep(p, vec3(3.60));
    float boxes = sdBox(r, vec3(0.40));
    float spheres = sdSphere(r, 0.43);
    float spheres2 = sdSphere(r, 0.35);
    //float d; 
    //d = boxes;
    //float d = min(plane, boxes);

    float d = max(-spheres, boxes * BOXES_STEPS);
    float d1 = min(spheres2, d);
    //float d1 = smin(spheres2, d, 0.95);
    d = mix(-d1, spheres2, 0.295);
    return d;
}

float RayMarch(vec3 ro, vec3 rd) {
    float dO=0.0;
    
    for(int i=0; i<MAX_STEPS; i++) {
        vec3 p = ro + rd*dO;
        float dS = GetDist(p);
        dO += dS;
        if(dO>MAX_DIST || abs(dS)<SURF_DIST) break;
    }
    
    return dO;
}

vec3 GetNormal(vec3 p) {
    float d = GetDist(p);
    vec2 e = vec2(EPSILON, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}

float GetLight(vec3 p) {
    vec3 lightPos = vec3(3, 5, 4);
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    
    float dif = clamp(dot(n, l)*.5+.5, 0., 1.);
    float d = RayMarch(p+n*SURF_DIST*2., l);
   // if(p.y<.01 && d<length(lightPos-p)) dif *= .5;
    
    return dif;
}

vec3 R(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = p+f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i-p);
    return d;
}


//void mainImage(out vec4 fragColor, in vec2 fragCoord)
vec4 mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    float tw = tw();

    vec2 uv = (2. * fragCoord.xy - iResolution.xy) / iResolution.x;
    //vec2 uv = (gl_FragCoord.xy - 0.5 * resolution.xy)  / resolution.y;
    float aspectRatio = iResolution.x / iResolution.y;
    uv.y += 0.5;
    
    vec2 m = vec2(0.001, 0.005) * mouse.xy * vec2(- aspectRatio, -1.0);
    //m += resolution.y / resolution.x;

    vec3 col = vec3(0);

    vec3 ro = vec3(0.0, 0.0, -3.0);   // i changed this ... this is flight through   
    // ro vec3 (l..r, o..u, distance)
    //vec3 ro = vec3(0.0);
    
    //ro.yz *= Rot(time);
    
    //ro *= Rotation3d(vec3(1.0, 0.0, 1.0), time);

    ro.xz *= Rot(0.1*time);
    
    ro.yz *= Rot(-m.y*3.14+1.55);
    ro.xz *= Rot(-m.x*8.);
    //ro.z += 12.;
    
    vec3 rd = R(uv, ro, vec3(0.0, 0.0, 0.0), +1.0);  // i changed this from vec3(0,1,0)

    float d = RayMarch(ro, rd);
    
    if(d < MAX_DIST)
    {
        vec3 p = ro + rd * d;
    
        float dif = GetLight(p);
        //col = vec3(dif);   
        col = GetNormal(p) * 0.5 + 0.5 - 0.5 * dif;
        //col = 0.2 * col;
        //float tpos = floor((sin(time*1.5)*0.5+0.5)*18.0);
        /* if (length(ti) <= abs(tpos))                          // tile position
        {
            col *= 10.; 
        } */ 
        //float fog0 = smoothstep(6.0, MAX_DIST, d);   // fog
        //col = mix(vec3(0.0), col, 90.1*fog0);
    }
    
    col = pow(col, vec3(.4545));    // gamma correction
    // fog #2
    float fog = 0.005;
    col *= 1.25 / (1.0  + pow(d, 3.0) * fog); // pow 2.0
    fragColor = vec4(col,1.0);
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.